/*
 * Decompiled with CFR 0.152.
 */
package com.roguewave.chart.overlay.overlays.v2_1;

import com.roguewave.chart.core.v2_1.ChartGraphics;
import com.roguewave.chart.core.v2_1.DataModel;
import com.roguewave.chart.datamodels.v2_1.DataModelConstants;
import com.roguewave.chart.drawables.device.v2_1.DeviceFilledRectangle;
import com.roguewave.chart.overlay.core.v2_1.ChartOverlay;
import com.roguewave.chart.overlay.core.v2_1.ParameterCalculator;
import com.roguewave.chart.overlay.core.v2_1.ScaleConstants;
import com.roguewave.chart.overlay.core.v2_1.Scaler;
import java.awt.Color;

public class BarChartOverlay
implements ChartOverlay,
DataModelConstants,
ScaleConstants {
    private int dataRow_;
    private int barWidth_;
    private Color color_;
    private boolean scale_;
    private double baseValue_ = 0.0;

    public BarChartOverlay(int row, int barWidth, Color color, boolean scale) {
        this.dataRow_ = row;
        if (row < 0) {
            throw new IllegalArgumentException("row < 0");
        }
        this.barWidth_ = barWidth;
        if (barWidth < 1) {
            throw new IllegalArgumentException("barWidth < 1");
        }
        if (this.barWidth_ % 2 == 0) {
            --this.barWidth_;
        }
        this.color_ = color;
        this.scale_ = scale;
    }

    public int getItemWidth() {
        return this.barWidth_;
    }

    public void addTo(ChartGraphics chartGraphics, DataModel data, int base, int left, int right, int offset, int columnWidth, ParameterCalculator params1, ParameterCalculator params2) {
        if (data.getRowCount() <= this.dataRow_) {
            return;
        }
        Scaler scaler = this.scale_ ? params1.getScaler() : params2.getScaler();
        int bars = data.getColumnCount();
        int totalLines = bars * this.barWidth_;
        int xi = left + offset - this.barWidth_ / 2;
        int spaceWidth = columnWidth - this.barWidth_;
        for (int i = 0; i < bars; ++i) {
            int height;
            int low;
            int y;
            int zero;
            double rawValue = data.getValue(this.dataRow_, i);
            if (rawValue == Double.NEGATIVE_INFINITY) {
                zero = -10000;
                y = -10000;
            } else {
                y = base - scaler.scale(rawValue);
                zero = base - scaler.scale(this.baseValue_);
                if (zero > base) {
                    zero = base;
                }
                if (rawValue >= 0.0) {
                    if (y > --zero) {
                        y = zero;
                    }
                } else if (y < ++zero) {
                    y = zero;
                }
                if (rawValue == 0.0) {
                    y = -1;
                    zero = -1;
                }
            }
            if (zero > y) {
                low = y;
                height = zero - y;
            } else {
                low = zero;
                height = y - zero;
            }
            chartGraphics.add2DDrawable(new DeviceFilledRectangle(xi, low, this.barWidth_, height + 1, this.color_));
            xi += columnWidth;
        }
    }

    public int getBarWidth() {
        return this.barWidth_;
    }

    public void setBarWidth(int width) {
        this.barWidth_ = width;
        if (this.barWidth_ % 2 == 0) {
            --this.barWidth_;
        }
    }

    public double getBaseValue() {
        return this.baseValue_;
    }

    public void setBaseValue(double value) {
        this.baseValue_ = value;
    }

    public Color getColor() {
        return this.color_;
    }

    public void setColor(Color color) {
        this.color_ = color;
    }

    public int getDataRow() {
        return this.dataRow_;
    }

    public void setDataRow(int dataRow) {
        if (dataRow < 0) {
            throw new IllegalArgumentException("dataRow < 0");
        }
        this.dataRow_ = dataRow;
    }

    public boolean getScale() {
        return this.scale_;
    }

    public void setScale(boolean scale) {
        this.scale_ = scale;
    }
}

